/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.throwable;

import io.gitlab.jfronny.commons.throwable.ExceptionWrapper;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ThrowingRunnable<TEx extends Throwable> {
    @NotNull
    public static ThrowingRunnable<RuntimeException> of(@NotNull Runnable runnable) {
        return Objects.requireNonNull(runnable)::run;
    }

    public void run() throws TEx;

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingRunnable<TEx> compose(@NotNull ThrowingRunnable<? extends TEx> before) {
        Objects.requireNonNull(before);
        return () -> {
            before.run();
            this.run();
        };
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingRunnable<TEx> andThen(@NotNull ThrowingRunnable<? extends TEx> after) {
        Objects.requireNonNull(after);
        return () -> {
            this.run();
            after.run();
        };
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Runnable addHandler(@NotNull Consumer<Throwable> handler) {
        Objects.requireNonNull(handler);
        return () -> {
            try {
                this.run();
            }
            catch (Throwable e) {
                handler.accept(e);
            }
        };
    }

    @Contract(value="_, _ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Runnable addHandler(@NotNull Class<TEx> exception, @NotNull Consumer<TEx> handler) {
        Objects.requireNonNull(exception);
        Objects.requireNonNull(handler);
        return () -> {
            try {
                this.run();
            }
            catch (Throwable e) {
                if (exception.isAssignableFrom(e.getClass())) {
                    handler.accept(e);
                }
                throw ExceptionWrapper.wrap(e);
            }
        };
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Runnable orThrow() {
        return this.orThrow(ExceptionWrapper::wrap)::run;
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <TEx1 extends Throwable> ThrowingRunnable<TEx1> orThrow(@NotNull Function<Throwable, TEx1> generator) {
        Objects.requireNonNull(generator);
        return () -> {
            try {
                this.run();
            }
            catch (Throwable e) {
                throw (Throwable)generator.apply(e);
            }
        };
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    default public Runnable assumeSafe() {
        ThrowingRunnable runnable = this;
        return runnable::run;
    }
}

